/* ========================================================*/
/* TOC */
/* ========================================================*/

// mobile

var ismobile = /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);


// limits

var debounceTime = 200;
var defaultWidthTOC = 270;
var minWidthTOC = 20;
var rightOffsetTOC = 20;
var resizeBarWidthDesktop = 5;
var resizeBarWidthMobile = 20;
var resizeBarWidth = ismobile ? resizeBarWidthMobile : resizeBarWidthDesktop;
var toggleButtonWidthDesktop = 10;
var toggleButtonWidthMobile = 20;
var toggleButtonWidth = ismobile ? toggleButtonWidthMobile : toggleButtonWidthDesktop;
var resizeableTOCminWidth = 400;
var autoCloseTOCminWidth = 480;
var contentBodyMinWidth = 200;
var resizeBarLeftOffsetPadding = 5;


// state

var isClosed = localStorage ? localStorage.getItem("navigationClosed") == "true" : false;
var resizeBarLeftOffset = localStorage ? (Number(localStorage.getItem("navigationResizeBar")) || defaultWidthTOC): defaultWidthTOC;


// prepare DOM

function prepareDOMforTOC() 
{
	$("#contentBody").addClass("forceCloseLeft");
	$("#navigation").addClass("forceCloseWidth");
	
	$("#navigationResizeBar").css("width", resizeBarWidth + "px");	
	$("#navigationResizeBar").hide();

	$("#show-hide-navigation").css("width", toggleButtonWidth + "px");
	
	$(".logo").css("background-position", "0% 50%");
}


// check if loaded

function checkTOCLoaded() 
{
    if ($("#toc").hasClass("loading")) 
	{
        window.setTimeout(checkTOCLoaded, debounceTime);
    } 
	else 
	{
        window.setTimeout(toggleTOC, debounceTime);        
    }
}


// toggle TOC open <> close

function toggleTOC() 
{
	if (isClosed) 
	{
		// MadCap call ->
		ShowHideNavigation("hide");
	}

	$("#show-hide-navigation").unbind().click(function(e)
	{
		e.stopPropagation();
		e.preventDefault();
		
		if (!isClosed) 
		{
			closeTOC();             
		}
		else
		{
			openTOC();
		}
	});
	
	var eventUp = ismobile ? "touchend" : "mouseup";
	var eventDown = ismobile ? "touchstart" : "mousedown";
	var eventMove = ismobile ? "touchmove" : "mousemove";

	
	$("#navigationResizeBar").unbind().bind(eventDown, function (e) 
	{
		e.preventDefault();
		
		if (e.target.id == "show-hide-navigation" || (ismobile && window.innerWidth < resizeableTOCminWidth) || isClosed) 
		{
			return;
		}	

		$("#navigationResizeBar").css("width", 200 + "px");	// arbitrary padding for debounce
				
		$(window).bind(eventMove, function (e) 
		{
			var tmpLeftOffset = e.pageX;
			
			if (e.originalEvent.touches) 
			{
				tmpLeftOffset = e.originalEvent.touches[0].pageX;
			}

			if (tmpLeftOffset < minWidthTOC) 
			{
				return;
			}
			
			if (tmpLeftOffset > window.innerWidth - contentBodyMinWidth) 
			{
				return;
			}
			
			setTOCResizeBarPosition(tmpLeftOffset);
		});
		
		$(window).bind(eventUp, function (e) 
		{
			$(window).unbind(eventMove);
			$(window).unbind(eventUp);
			
			$("#navigationResizeBar").css("width", resizeBarWidth + "px");	
		});
	});
	
	$("#navigationResizeBar").show();
}


// open TOC

function openTOC()
{
    $("#navigationResizeBar").removeClass("forceCloseLeft");
    $("#navigationResizeBar").removeClass("nav-closed");
    $("#contentBody").removeClass("forceCloseLeft");
    $("#contentBody").removeClass("nav-closed");
    $("#navigation").removeClass("forceCloseWidth");
    $("#navigation").removeClass("nav-closed");
    
    $("#navigationResizeBar").css('left', String(resizeBarLeftOffset) + "px");
    $("#contentBody").css('left', String(resizeBarLeftOffset + resizeBarLeftOffsetPadding) + "px");
    $("#navigation").css('width', String(resizeBarLeftOffset) + "px");
    
    $("#navigationResizeBar").attr("data-mc-last-width", resizeBarLeftOffset);
    $("#contentBody").attr("data-mc-last-width", resizeBarLeftOffset + resizeBarLeftOffsetPadding);
    $("#navigation").attr("data-mc-last-width", resizeBarLeftOffset);
        
    isClosed = false;
    
    if (localStorage) 
	{
		localStorage.setItem("navigationClosed", false);
	}
    
    $(window).trigger('resize');
}


// close TOC

function closeTOC()
{    
    $("#navigationResizeBar").addClass("forceCloseLeft");
    $("#contentBody").addClass("forceCloseLeft");
    $("#navigation").addClass("forceCloseWidth");
    
	// MadCap call ->
    ShowHideNavigation("hide");
        
    isClosed = true;
    
    if (localStorage) 
	{
		localStorage.setItem("navigationClosed", true);
	}
    
    $(window).trigger('resize');
}


// set resize bar

function setTOCResizeBarPosition(offset)
{
	if (offset < minWidthTOC)
	{
		offset = minWidthTOC;
	}
	
	$("#navigationResizeBar").css('left', String(offset) + "px");
	$("#contentBody").css('left', String(offset + resizeBarLeftOffsetPadding) + "px");
	$("#navigation").css('width', String(offset) + "px");
	
	$("#navigationResizeBar").attr("data-mc-last-width", offset);
	$("#contentBody").attr("data-mc-last-width", offset + resizeBarLeftOffsetPadding);
	$("#navigation").attr("data-mc-last-width", offset);
	
	resizeBarLeftOffset = offset;
	
	if (localStorage) 
	{
		localStorage.setItem("navigationResizeBar", resizeBarLeftOffset);
	}
}


// resize TOC elements

function resizeHandlerTOC() 
{
	if ($('#contentBody').width() < contentBodyMinWidth) 
	{
		$('.previous-topic-button').hide();
		$('.next-topic-button').hide();
		
		setTOCResizeBarPosition(window.innerWidth - contentBodyMinWidth);
	}
	else
	{
		$('.previous-topic-button').show();
		$('.next-topic-button').show();
	}
}


// auto close TOC on location hash change if window to small

function locationHashHandlerTOC() 
{
    if (window.innerWidth < autoCloseTOCminWidth)
	{
        closeTOC();
    }
}


// init TOC

function initTOC() 
{
	prepareDOMforTOC();
	
	if (window.innerWidth < autoCloseTOCminWidth)
	{
        isClosed = true;
		
        resizeBarLeftOffset = window.innerWidth - rightOffsetTOC;
    }
    
    if (isClosed) 
	{
        closeTOC();
    } 
	else
	{
        openTOC();
    }
    
    checkTOCLoaded();
	
	$(window).on('resize', resizeHandlerTOC);
	
    $(window).trigger('resize');
	
	window.onhashchange = locationHashHandlerTOC;
}


// TOC document ready handler

$(document).ready(function() 
{
	initTOC();
});

/* ========================================================*/
/* HEADER */
/* ========================================================*/

// limits

var smallModeSwitchWidth = 768;
var smallModeLogoSwitchWidth = 235;
var smallModeLogoMinSwitchWidth = 100;
var minLogoWidth = 40;
var maxLogoWidth = 169;
var minProductDropdownWidth = 100;
var maxProductDropdownWidth = 175;
var minProductDropdownSwitch = 410;
var logoLeftOffset = 40;
var minSearchInputWidth = 50;
var maxSearchInputWidth = 190;
var headerCutoffWidth = 60;


// resize header elements

function resizeHandlerHeader() 
{
	if (window.innerWidth < smallModeSwitchWidth) 
	{
		var diff = smallModeSwitchWidth - window.innerWidth;
		var width = maxSearchInputWidth - diff;
		width = width < minSearchInputWidth ? minSearchInputWidth : width;
		
		$('#search-field').css("width", width + "px");
	}
	else
	{
		$('#search-field').css("width", maxSearchInputWidth + "px");
	}
	
	var productDropdown = $('#productDropdown');
	var versionDropdown = $('#versionDropdown');
	var searchBar = $('.search-bar');
	
	if (window.innerWidth < minProductDropdownSwitch) 
	{
		var diff = minProductDropdownSwitch - window.innerWidth;
		var width = maxProductDropdownWidth - diff;
		width = width < minProductDropdownWidth ? minProductDropdownWidth : width;
		
		productDropdown.css("width", width + "px");
	}
	else
	{
		productDropdown.css("width", maxProductDropdownWidth + "px");
	}
	
	if (productDropdown.length > 0)
	{
		productDropdown.show();
	}
	
	if (versionDropdown.length > 0)
	{
		versionDropdown.show();
	}
	
	if (searchBar.length > 0)
	{
		searchBar.show();
	}
		
	if(productDropdown.length > 0 && productDropdown.offset().left < headerCutoffWidth)
	{
		productDropdown.hide();
	}
	
	if(versionDropdown.length > 0 && versionDropdown.offset().left < headerCutoffWidth)
	{
		versionDropdown.hide();
	}
	
	if(searchBar.length > 0 && searchBar.offset().left < headerCutoffWidth)
	{
		searchBar.hide();
	}
	
	var leftMost = searchBar.offset().left;

	if(productDropdown.length > 0)
	{
		leftMost = productDropdown.offset().left;
	}
	
	if (leftMost < smallModeLogoSwitchWidth) 
	{
		$('.logo').css("width", minLogoWidth + "px");
	}
	else
	{
		$('.logo').css("width", maxLogoWidth + "px");
	}
	
	var diff = smallModeLogoMinSwitchWidth - leftMost;
	
	if (leftMost < smallModeLogoMinSwitchWidth) 
	{
		var width = logoLeftOffset - diff;
		width = width < 0 ? 0 : width;
		
		$('.logo').css("left", width + "px");
	}
	else
	{
		$('.logo').css("left", logoLeftOffset + "px");
	}
}


// init header

function initHeader() 
{	
	$(window).on('resize', resizeHandlerHeader);
	
    $(window).trigger('resize');
}


// HEADER document ready handler

$(document).ready(function() 
{
	initHeader();
});


/* ========================================================*/
/* IMPRINT */
/* ========================================================*/

// localise imprint

function setImprint()
{
	var language = currentLanguage || "en-US";
	
	var imp = "";

	if (language == "en-US")
	{
	   imp = '<a href="https://www.maxon.net/en/legal" target="_blank">© MAXON Computer - Impressum</a>';
	}
	
	if (language == "de-DE")
	{
	   imp = '<a href="https://www.maxon.net/de/legal" target="_blank">© MAXON Computer - Impressum</a>';
	}
	
	if (language == "es-ES")
	{
	   imp = '<a href="https://www.maxon.net/es/legal" target="_blank">© MAXON Computer - Imprimir</a>';
	}
	
	if (language == "fr-FR")
	{
	   imp = '<a href="https://www.maxon.net/fr/legal" target="_blank">© MAXON Computer - Colophon</a>';
	}
	
	if (language == "it-IT")
	{
	   imp = '<a href="https://www.maxon.net/it/legal" target="_blank">© MAXON Computer - Dati Aziendali</a>';
	}
	
	if (language == "ja-JP")
	{
	   imp = '<a href="https://www.maxon.net/ja/legal" target="_blank">© MAXON Computer - 利用規約</a>';
	}
	
	if (language == "ko-KR")
	{
	   imp = '<a href="https://www.maxon.net/ko/legal" target="_blank">© MAXON Computer - 날인</a>';
	}
	
	if (language == "ru-RU")
	{
	   imp = '<a href="https://www.maxon.net/ru/legal" target="_blank">© MAXON Computer - ВХОДНЫЕ ДАННЫЕ</a>';
	}

	$('#body').after('<footer id="footer">' + imp + '</footer>');
}


// IMPRINT document ready handler

$(document).ready(function() 
{
	setImprint();
});